<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Justificativa Entity
 *
 * @property int $id
 * @property int $vulnerabilidades_id
 * @property int $status_id
 * @property string|null $descricao
 * @property \Cake\I18n\Date|null $data_alvo
 * @property \Cake\I18n\DateTime|null $create_time
 * @property \Cake\I18n\DateTime|null $update_time
 *
 * @property \App\Model\Entity\Vulnerabilidade $vulnerabilidade
 * @property \App\Model\Entity\Status $status
 */
class Justificativa extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'vulnerabilidade_id' => true,
        'descricao' => true,
        'data_alvo' => true,
        'create_time' => true,
        'update_time' => true,
        'status' => true,
    ];
}
