<?php
declare(strict_types=1);

namespace App\Controller;
use Cake\ORM\TableRegistry;

/**
 * Temp Controller
 *
 * @property \App\Model\Table\TempTable $Temp
 */
class TempController extends AppController
{
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $query = $this->Temp->find();
        $temp = $this->paginate($query);

        $this->set(compact('temp'));
    }

    /**
     * View method
     *
     * @param string|null $id Temp id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $temp = $this->Temp->get($id, contain: []);
        $this->set(compact('temp'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $temp = $this->Temp->newEmptyEntity();
        if ($this->request->is('post')) {
            $temp = $this->Temp->patchEntity($temp, $this->request->getData());
            if ($this->Temp->save($temp)) {
                $this->Flash->success(__('The temp has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The temp could not be saved. Please, try again.'));
        }
        $this->set(compact('temp'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Temp id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $temp = $this->Temp->get($id, contain: []);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $temp = $this->Temp->patchEntity($temp, $this->request->getData());
            if ($this->Temp->save($temp)) {
                $this->Flash->success(__('The temp has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The temp could not be saved. Please, try again.'));
        }
        $this->set(compact('temp'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Temp id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $temp = $this->Temp->get($id);
        if ($this->Temp->delete($temp)) {
            $this->Flash->success(__('The temp has been deleted.'));
        } else {
            $this->Flash->error(__('The temp could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }


    public function comparar($comparar = null)
    {
              

        $temps = $this->Temp->find('All');
        $x = 0;
        $y = 0;
        $z = 0;
        $novos;
        $repetidos;
        $reabertos;
        if ($comparar == 1){ 
            foreach ($temps as $temp){
                $result = TableRegistry::getTableLocator()->get('Vulnerabilidades')->find()->where(['ip =' => $temp->ip,'nessus_plugin_cve =' => $temp->nessus_plugin_cve])->all()->toList();
                
                if (!empty($result)) {
                    
                    $temp->controle = 1;
                    if ($result[0]->close_time != null){ //Verifica se já está fechado e se estiver altera o controle para reaberto
                        $temp->controle = 2;
                        $reabertos[$z]['hostname'] = $temp->hostname;
                        $reabertos[$z]['nessus_plugin_cve'] = $temp->nessus_plugin_cve;
                        $z = $z + 1;
                    }
                    if ($this->Temp->save($temp)) {
                        //$this->Flash->success(__($temp->hostname.' - '.$temp->nessus_plugin_cve.' -> '.'Vulnerabilidade já existente.'));
                        $repetidos[$x]['hostname'] = $temp->hostname;
                        $repetidos[$x]['nessus_plugin_cve'] = $temp->nessus_plugin_cve;
                        $x = $x + 1;
                    }else{
                        //$this->Flash->error(__('A vulnerabilidade não pode ser verificada.'));
                    }

                }else{
                    $novos[$y]['hostname'] = $temp->hostname;
                    $novos[$y]['nessus_plugin_cve'] = $temp->nessus_plugin_cve;
                    $y = $y + 1;
                }
            
            }
            $this->set(compact('repetidos', 'novos', 'reabertos'));
        }
        


    }

    public function truncate($controle = null)
    {
        $result;
        if ($controle == 1){
            $result = $this->Temp->deleteAll([]);
            
        } 
        $this->set(compact('result','controle'));   

    }


    
}
