<?php
declare(strict_types=1);

namespace App\Controller;
use Cake\ORM\TableRegistry;
use Cake\ORM\Locator\LocatorAwareTrait;



/**
 * Justificativas Controller
 *
 * @property \App\Model\Table\JustificativasTable $Justificativas
 */
class JustificativasController extends AppController
{
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */




    public function index()
    {
        $query = $this->Justificativas->find()->contain(['Vulnerabilidades']);
        $justificativas = $this->paginate($query);
        #$vulnerabilidades = $this->Justificativas->Vulnerabilidades->find('list', limit: 200)->all();
        $this->set(compact('justificativas'));
    }


    /**
     * View method
     *
     * @param string|null $id Justificativa id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $justificativa = $this->Justificativas->get($id, contain: ['Vulnerabilidades']);
        $this->set(compact('justificativa'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $justificativa = $this->Justificativas->newEmptyEntity();
        if ($this->request->is('post')) {
            $justificativa = $this->Justificativas->patchEntity($justificativa, $this->request->getData());
            if ($this->Justificativas->save($justificativa)) {
                $this->Flash->success(__('The justificativa has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The justificativa could not be saved. Please, try again.'));
        }
        $vulnerabilidades = $this->Justificativas->Vulnerabilidades->find('list', limit: 200)->all();
        $this->set(compact('justificativa', 'vulnerabilidades'));
    }
    public function addone($id = null)
    {
          
        $justificativa = $this->Justificativas->newEmptyEntity();
        $vulnerabilidades = $this->Justificativas->Vulnerabilidades->find()->where(['id = ' => $id])->first();
        $status = TableRegistry::getTableLocator()->get('Status')->find('list')->all();
        
        if ($this->request->is('post')) {
            $justificativa = $this->Justificativas->patchEntity($justificativa, $this->request->getData());
            if ($this->Justificativas->save($justificativa)) {
                $this->Flash->success(__('The justificativa has been saved.'));

                return $this->redirect(['controller' => 'Vulnerabilidades' , 'action' => 'editstatus', $id, $this->request->getData()['status']]);
            }
            $this->Flash->error(__('The justificativa could not be saved. Please, try again.'));
        }
        $vulnerabilidades = $this->Justificativas->Vulnerabilidades->find()->where(['id = ' => $id])->first();
        $this->set(compact('justificativa', 'vulnerabilidades', 'status'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Justificativa id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $justificativa = $this->Justificativas->get($id, contain: []);
        $status = TableRegistry::getTableLocator()->get('Status')->find('list')->all();
        if ($this->request->is(['patch', 'post', 'put'])) {
            $justificativa = $this->Justificativas->patchEntity($justificativa, $this->request->getData());
            if ($this->Justificativas->save($justificativa)) {
                $this->Flash->success(__('The justificativa has been saved.'));

                return $this->redirect(['controller' => 'Vulnerabilidades' , 'action' => 'editstatus', $justificativa->vulnerabilidade_id, $this->request->getData()['status']]);
            }
            $this->Flash->error(__('The justificativa could not be saved. Please, try again.'));
        }
        $vulnerabilidades = $this->Justificativas->Vulnerabilidades->find('list', limit: 200)->all();
        $this->set(compact('justificativa', 'vulnerabilidades','status'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Justificativa id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $justificativa = $this->Justificativas->get($id);
        if ($this->Justificativas->delete($justificativa)) {
            $this->Flash->success(__('The justificativa has been deleted.'));
        } else {
            $this->Flash->error(__('The justificativa could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }

}
