<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Vulnerabilidade[]|\Cake\Collection\CollectionInterface $vulnerabilidades
 */
 
?>
<?php
$this->assign('title', __('Novas Vulnerabilidades'));
$this->Breadcrumbs->add([
    ['title' => __('Home'), 'url' => '/'],
    ['title' => __('Vulnerabilidades adicionadas')],
]);
?>

<div class="card card-primary card-outline">
    <div class="card-header d-flex flex-column flex-md-row">
        <h2 class="card-title">
            Vulnerabilidades adicionadas
        </h2>
        <div class="d-flex ml-auto">
            <?php 
                echo $this->Html->link(__('Apagar tabela temp?'), ['controller' => 'temp', 'action' => 'truncate'], ['class' => 'btn btn-primary btn-sm ml-2']);
              ?>  
        </div>
    </div>
    <!-- /.card-header -->
    <!-- /.card-header -->
    <div class="card-body table-responsive p-0">
        <table class="table table-hover text-nowrap">
            <thead>
                <tr>
                    <th>Hostname</th>
                    <th>Nessus Plugin CVE</th>
                </tr>
            </thead>
            <tbody>

                <?php foreach ($novos as $novo) : ?>
                    <tr>

                        <td><?= $novo['hostname'] ?></td>


                        <td><?= $novo['nessus_plugin_cve'] ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

    <div class="card-header d-flex flex-column flex-md-row">
        <h2 class="card-title">
            Vulnerabilidades reabertas
        </h2>
        <div class="d-flex ml-auto">
  
        </div>
    </div>
    <!-- /.card-header -->
    <!-- /.card-header -->
    <div class="card-body table-responsive p-0">
        <table class="table table-hover text-nowrap">
            <thead>
                <tr>
                    <th>Hostname</th>
                    <th>Nessus Plugin CVE</th>
                </tr>
            </thead>
            <tbody>

                <?php foreach ($reabertos as $reaberto) : ?>
                    <tr>

                        <td><?= $reaberto['hostname'] ?></td>


                        <td><?= $reaberto['nessus_plugin_cve'] ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

    <div class="card-header d-flex flex-column flex-md-row">
        <h2 class="card-title">
            Vulnerabilidades fechadas
        </h2>
        <div class="d-flex ml-auto">
  
        </div>
    </div>
    <!-- /.card-header -->
    <!-- /.card-header -->
    <div class="card-body table-responsive p-0">
        <table class="table table-hover text-nowrap">
            <thead>
                <tr>
                    <th>Hostname</th>
                    <th>Nessus Plugin CVE</th>
                </tr>
            </thead>
            <tbody>

                <?php foreach ($fechados as $fechado) : ?>
                    <tr>

                        <td><?= $fechado['hostname'] ?></td>


                        <td><?= $fechado['nessus_plugin_cve'] ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

    <!-- /.card-body -->

    <!-- /.card-footer -->
</div>
