<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Vulnerabilidade[]|\Cake\Collection\CollectionInterface $vulnerabilidades
 */
 error_reporting(0);
?>

<?php
$this->assign('title', __('Vulnerabilidades'));
$this->Breadcrumbs->add([
    ['title' => __('Home'), 'url' => '/'],
    ['title' => __('List Vulnerabilidades')],
]);
$editar = 0;

?>


<div class="card card-primary card-outline">
    <div class="card-header d-flex flex-column flex-md-row">
        <h2 class="card-title">
            <?= $this->Form->create($vulnerabilidades,['type' => 'get', 'url' => ['action' => 'search']]) ?>
                <?= $this->Form->select('coluna', ['ip' => 'IP', 'hostname' => 'Hostname', 'nessus_plugin_id' => 'Nessus Plugin', 'nessus_plugin_cve' => 'Nessus Plugin CVE', 'tipo' => 'Tipo']) ?>
                <?= $this->Form->select('operador', ['=' => 'Igual', '!=' => 'Diferente', 'like' => 'Like']) ?>
                <?= $this->Form->text('valor',['placeholder' => 'Valor','required' => True]) ?>                     
                <?= $this->Form->submit('Pesquisar') ?>
            </form>

        </h2>
        <div class="d-flex ml-auto">
            <?= $this->Paginator->limitControl([], null, [
                'label' => false,
                'class' => 'form-control form-control-sm',
                'templates' => ['inputContainer' => '{{content}}']
            ]); ?>
            <?= $this->Html->link(__('New Vulnerabilidade'), ['action' => 'add'], ['class' => 'btn btn-primary btn-sm ml-2']) ?>
        </div>
    </div>
    <!-- /.card-header -->
    <div class="card-body table-responsive p-0">
        <table class="table table-hover text-nowrap">
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('grupo') ?></th>
                    <th><?= $this->Paginator->sort('servico') ?></th>
                    <th><?= $this->Paginator->sort('ip') ?></th>
                    <th><?= $this->Paginator->sort('hostname') ?></th>
                    <th><?= $this->Paginator->sort('nessus_plugin_id') ?></th>
                    <th><?= $this->Paginator->sort('nessus_plugin_cve') ?></th>
                    <th><?= $this->Paginator->sort('gravidade') ?></th>
                    <th><?= $this->Paginator->sort('score') ?></th>
                    <th><?= $this->Paginator->sort('tempo_em_dias') ?></th>
                    <th><?= $this->Paginator->sort('visto_em') ?></th>
                    <th><?= $this->Paginator->sort('patch') ?></th>
                    <th><?= $this->Paginator->sort('cve_critica_comunicada') ?></th>
                    <th><?= $this->Paginator->sort('tipo') ?></th>
                    <th><?= $this->Paginator->sort('catalogo') ?></th>
                    
                    <th><?= $this->Paginator->sort('audit') ?></th>
                    <th><?= $this->Paginator->sort('data_gerado_nessus') ?></th>
                    <th><?= $this->Paginator->sort('status_id') ?></th>
                    <th><?= $this->Paginator->sort('Justificativa') ?></th>
                    <th><?= $this->Paginator->sort('close_time') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>

                <?php foreach ($vulnerabilidades as $vulnerabilidade) : ?>
                    <tr>

                        <td><?= $this->Number->format($vulnerabilidade->id) ?></td>

                        <td><?= h($vulnerabilidade->grupo) ?></td>
                        <td><?= h($vulnerabilidade->servico) ?></td>
                        <td><?= h($vulnerabilidade->ip) ?></td>
                        <td><?= h($vulnerabilidade->hostname) ?></td>
                        <td><?= h($vulnerabilidade->nessus_plugin_id) ?></td>
                        <td><?= h($vulnerabilidade->nessus_plugin_cve) ?></td>
                        <td><?= h($vulnerabilidade->gravidade) ?></td>
                        <td><?= h($vulnerabilidade->score) ?></td>
                        <td><?= h($vulnerabilidade->tempo_em_dias) ?></td>
                        <td><?= h($vulnerabilidade->visto_em) ?></td>
                        <td><?= h($vulnerabilidade->patch) ?></td>
                        <td><?= h($vulnerabilidade->cve_critica_comunicada) ?></td>
                        <td><?= h($vulnerabilidade->tipo) ?></td>
                        <td><?= h($vulnerabilidade->catalogo) ?></td>
                        
                        <td><?= h($vulnerabilidade->audit) ?></td>
                        <td><?= h($vulnerabilidade->data_gerado_nessus) ?></td>
                        <td><?= h($vulnerabilidade->status->status) ?></td>
                        <td><?= h($vulnerabilidade->justificativa->descricao) ?></td>
                        <td><?= h($vulnerabilidade->close_time) ?></td>
                        <td class="actions">

                            <?php
                            if (isset($vulnerabilidade->justificativa->id)){
                                ?>
                                <?=($this->Html->link(__('Editar justificativa'), ['controller' => 'justificativas', 'action' => 'edit', $vulnerabilidade->justificativa->id], ['class' => 'btn btn-xs btn-outline-primary', 'escape' => false]));?>
                                <?php
                                
                                
                            } else{
                                ?><?=$this->Html->link(__('Incluir justificativa'), ['controller' => 'justificativas', 'action' => 'addone', $vulnerabilidade->id], ['class' => 'btn btn-xs btn-outline-primary', 'escape' => false]) ;?>
                                <?php
                            }?>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <!-- /.card-body -->
    <div class="card-footer d-flex flex-column flex-md-row">
        <div class="text-muted">
            <?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?>
        </div>
        <ul class="pagination pagination-sm mb-0 ml-auto">
            <?= $this->Paginator->first('<i class="fas fa-angle-double-left"></i>', ['escape' => false]) ?>
            <?= $this->Paginator->prev('<i class="fas fa-angle-left"></i>', ['escape' => false]) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next('<i class="fas fa-angle-right"></i>', ['escape' => false]) ?>
            <?= $this->Paginator->last('<i class="fas fa-angle-double-right"></i>', ['escape' => false]) ?>
        </ul>
    </div>
    <!-- /.card-footer -->
</div>