<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Vulnerabilidade $vulnerabilidade
 */
?>

<?php
$this->assign('title', __('Add Vulnerabilidade'));
$this->Breadcrumbs->add([
    ['title' => __('Home'), 'url' => '/'],
    ['title' => __('List Vulnerabilidades'), 'url' => ['action' => 'index']],
    ['title' => __('Add')],
]);
?>

<div class="card card-primary card-outline">
    <?= $this->Form->create($vulnerabilidade, ['valueSources' => ['query', 'context']]) ?>
    <div class="card-body">
        <?= $this->Form->control('grupo') ?>
        <?= $this->Form->control('servico') ?>
        <?= $this->Form->control('ip') ?>
        <?= $this->Form->control('hostname') ?>
        <?= $this->Form->control('nessus_plugin_id') ?>
        <?= $this->Form->control('nessus_plugin_cve') ?>
        <?= $this->Form->control('gravidade') ?>
        <?= $this->Form->control('score') ?>
        <?= $this->Form->control('tempo_em_dias') ?>
        <?= $this->Form->control('visto_em') ?>
        <?= $this->Form->control('patch') ?>
        <?= $this->Form->control('cve_critica_comunicada') ?>
        <?= $this->Form->control('tipo') ?>
        <?= $this->Form->control('catalogo') ?>
        <?= $this->Form->control('status_id') ?>
        <?= $this->Form->control('audit') ?>
        <?= $this->Form->control('data_gerado_nessus', ['empty' => true]) ?>
        <?= $this->Form->control('create_time') ?>
        <?= $this->Form->control('update_time') ?>
        <?= $this->Form->control('close_time') ?>
    </div>
    <div class="card-footer d-flex">
        <div class="ml-auto">
            <?= $this->Form->button(__('Save'), ['class' => 'btn btn-primary']) ?>
            <?= $this->Html->link(__('Cancel'), ['action' => 'index'], ['class' => 'btn btn-default']) ?>
        </div>
    </div>
    <?= $this->Form->end() ?>
</div>