<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Temp $temp
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Temp'), ['action' => 'edit', $temp->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Temp'), ['action' => 'delete', $temp->id], ['confirm' => __('Are you sure you want to delete # {0}?', $temp->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Temp'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Temp'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="temp view content">
            <h3><?= h($temp->id) ?></h3>
            <table>
                <tr>
                    <th><?= __('Grupo') ?></th>
                    <td><?= h($temp->grupo) ?></td>
                </tr>
                <tr>
                    <th><?= __('Servico') ?></th>
                    <td><?= h($temp->servico) ?></td>
                </tr>
                <tr>
                    <th><?= __('Ip') ?></th>
                    <td><?= h($temp->ip) ?></td>
                </tr>
                <tr>
                    <th><?= __('Hostname') ?></th>
                    <td><?= h($temp->hostname) ?></td>
                </tr>
                <tr>
                    <th><?= __('Nessus Plugin Id') ?></th>
                    <td><?= h($temp->nessus_plugin_id) ?></td>
                </tr>
                <tr>
                    <th><?= __('Nessus Plugin Cve') ?></th>
                    <td><?= h($temp->nessus_plugin_cve) ?></td>
                </tr>
                <tr>
                    <th><?= __('Gravidade') ?></th>
                    <td><?= h($temp->gravidade) ?></td>
                </tr>
                <tr>
                    <th><?= __('Score') ?></th>
                    <td><?= h($temp->score) ?></td>
                </tr>
                <tr>
                    <th><?= __('Tempo Em Dias') ?></th>
                    <td><?= h($temp->tempo_em_dias) ?></td>
                </tr>
                <tr>
                    <th><?= __('Visto Em') ?></th>
                    <td><?= h($temp->visto_em) ?></td>
                </tr>
                <tr>
                    <th><?= __('Patch') ?></th>
                    <td><?= h($temp->patch) ?></td>
                </tr>
                <tr>
                    <th><?= __('Cve Critica Comunicada') ?></th>
                    <td><?= h($temp->cve_critica_comunicada) ?></td>
                </tr>
                <tr>
                    <th><?= __('Tipo') ?></th>
                    <td><?= h($temp->tipo) ?></td>
                </tr>
                <tr>
                    <th><?= __('Catalogo') ?></th>
                    <td><?= h($temp->catalogo) ?></td>
                </tr>
                <tr>
                    <th><?= __('Audit') ?></th>
                    <td><?= h($temp->audit) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($temp->id) ?></td>
                </tr>
            </table>
        </div>
    </div>
</div>