<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Justificativa $justificativa
 */
?>

<?php
$this->assign('title', __('Justificativa'));
$this->Breadcrumbs->add([
    ['title' => __('Home'), 'url' => '/'],
    ['title' => __('List Justificativas'), 'url' => ['action' => 'index']],
    ['title' => __('View')],
]);
?>

<div class="view card card-primary card-outline">
    <div class="card-header d-sm-flex">
        <h2 class="card-title"><?= h($justificativa->id) ?></h2>
    </div>
    <div class="card-body table-responsive p-0">
        <table class="table table-hover text-nowrap">
            <tr>
                <th><?= __('Vulnerabilidade') ?></th>
                <td><?= $justificativa->has('vulnerabilidade') ? $this->Html->link($justificativa->vulnerabilidade->id, ['controller' => 'Vulnerabilidades', 'action' => 'view', $justificativa->vulnerabilidade->id]) : '' ?></td>
            </tr>
            <tr>
                <th><?= __('Descricao') ?></th>
                <td><?= h($justificativa->descricao) ?></td>
            </tr>
            <tr>
                <th><?= __('Id') ?></th>
                <td><?= $this->Number->format($justificativa->id) ?></td>
            </tr>
            <tr>
                <th><?= __('Data Alvo') ?></th>
                <td><?= h($justificativa->data_alvo) ?></td>
            </tr>
            <tr>
                <th><?= __('Create Time') ?></th>
                <td><?= h($justificativa->create_time) ?></td>
            </tr>
            <tr>
                <th><?= __('Update Time') ?></th>
                <td><?= h($justificativa->update_time) ?></td>
            </tr>
        </table>
    </div>
    <div class="card-footer d-flex">
        <div class="mr-auto">
            <?= $this->Form->postLink(
                __('Delete'),
                ['action' => 'delete', $justificativa->id],
                ['confirm' => __('Are you sure you want to delete # {0}?', $justificativa->id), 'class' => 'btn btn-danger']
            ) ?>
        </div>
        <div class="ml-auto">
            <?= $this->Html->link(__('Edit'), ['action' => 'edit', $justificativa->id], ['class' => 'btn btn-secondary']) ?>
            <?= $this->Html->link(__('Cancel'), ['action' => 'index'], ['class' => 'btn btn-default']) ?>
        </div>
    </div>
</div>
