<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Justificativa $justificativa
 */
?>

<?php
$this->assign('title', __('Edit Justificativa'));
$this->Breadcrumbs->add([
    ['title' => __('Home'), 'url' => '/'],
    ['title' => __('List Justificativas'), 'url' => ['action' => 'index']],
    ['title' => __('View'), 'url' => ['action' => 'view', $justificativa->id]],
    ['title' => __('Edit')],
]);
?>

<div class="card card-primary card-outline">
    <?= $this->Form->create($justificativa) ?>
    <div class="card-body">
        <?= $this->Form->control('vulnerabilidade_id', ['options' => $vulnerabilidades, 'class' => 'form-control']) ?>
        <?= $this->Form->textarea('descricao',['rows' => '5', 'cols' => '5', 'label' => 'Descriação']) ?>
        <br>
        <label class="form-label">Status</label>
        <br>
        <?= $this->Form->control('status',['options' => $status,  'label' => '']) ?>
        <?= $this->Form->control('data_alvo', ['empty' => true]) ?>
        <?= $this->Form->control('create_time') ?>
        <?= $this->Form->control('update_time') ?>
    </div>
    <div class="card-footer d-flex">
        <div class="mr-auto">
            <?= $this->Form->postLink(
                __('Delete'),
                ['action' => 'delete', $justificativa->id],
                ['confirm' => __('Are you sure you want to delete # {0}?', $justificativa->id), 'class' => 'btn btn-danger']
            ) ?>
        </div>
        <div class="ml-auto">
            <?= $this->Form->button(__('Save'), ['class' => 'btn btn-primary']) ?>
            <?= $this->Html->link(__('Cancel'), ['action' => 'view', $justificativa->id], ['class' => 'btn btn-default']) ?>
        </div>
    </div>
    <?= $this->Form->end() ?>
</div>