<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Justificativa $justificativa
 */
?>

<?php
$this->assign('title', __('Add Justificativa'));
$this->Breadcrumbs->add([
    ['title' => __('Home'), 'url' => '/'],
    ['title' => __('List Justificativas'), 'url' => ['action' => 'index']],
    ['title' => __('Add')],
]);
?>

<div class="card card-primary card-outline">
    <?= $this->Form->create($justificativa, ['valueSources' => ['query', 'context']]) ?>
    <div class="card-body">
        <?= $this->Form->hidden('vulnerabilidade_id', ['Value' => $vulnerabilidades->id]) ?>

        <?= $this->Form->control('ip', ['Value' => $vulnerabilidades->ip, 'label' => 'IP']) ?>
        <?= $this->Form->control('hostname', ['Value' => $vulnerabilidades->hostname, 'label' => 'hostname']) ?>
        <?= $this->Form->control('nessus_plugin_cve', ['Value' => $vulnerabilidades->nessus_plugin_cve, 'label' => 'Nessus CVE']) ?>
        

        <label class="form-label" for="nessus-plugin-cve">Decrição</label>
        <?= $this->Form->textarea('descricao',['rows' => '5', 'cols' => '5', 'label' => 'Descriação']) ?>
        <br>
        <label class="form-label">Status</label>
        <br>
        <?= $this->Form->control('status',['options' => $status,  'label' => '']) ?>

        

        <?= $this->Form->control('data_alvo', ['empty' => true]) ?>

    </div>
    <div class="card-footer d-flex">
        <div class="ml-auto">
            <?= $this->Form->button(__('Save'), ['class' => 'btn btn-primary']) ?>
            <?= $this->Html->link(__('Cancel'), ['action' => 'index'], ['class' => 'btn btn-default']) ?>
        </div>
    </div>
    <?= $this->Form->end() ?>

    
    
    
    
</div>