<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Justificativa $justificativa
 */
?>

<?php
$this->assign('title', __('Add Justificativa'));
$this->Breadcrumbs->add([
    ['title' => __('Home'), 'url' => '/'],
    ['title' => __('List Justificativas'), 'url' => ['action' => 'index']],
    ['title' => __('Add')],
]);
?>

<div class="card card-primary card-outline">
    <?= $this->Form->create($justificativa, ['valueSources' => ['query', 'context']]) ?>
    <div class="card-body">
        <?= $this->Form->control('vulnerabilidade_id', ['options' => $vulnerabilidades, 'class' => 'form-control']) ?>
        <?= $this->Form->control('descricao') ?>
        <?= $this->Form->control('data_alvo', ['empty' => true]) ?>
        <?= $this->Form->control('create_time') ?>
        <?= $this->Form->control('update_time') ?>
    </div>
    <div class="card-footer d-flex">
        <div class="ml-auto">
            <?= $this->Form->button(__('Save'), ['class' => 'btn btn-primary']) ?>
            <?= $this->Html->link(__('Cancel'), ['action' => 'index'], ['class' => 'btn btn-default']) ?>
        </div>
    </div>
    <?= $this->Form->end() ?>
</div>