<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Cmdb $cmdb
 */
?>

<?php
$this->assign('title', __('Cmdb'));
$this->Breadcrumbs->add([
    ['title' => __('Home'), 'url' => '/'],
    ['title' => __('List Cmdb'), 'url' => ['action' => 'index']],
    ['title' => __('View')],
]);
?>

<div class="view card card-primary card-outline">
    <div class="card-header d-sm-flex">
        <h2 class="card-title"><?= h($cmdb->name) ?></h2>
    </div>
    <div class="card-body table-responsive p-0">
        <table class="table table-hover text-nowrap">
            <tr>
                <th><?= __('Name') ?></th>
                <td><?= h($cmdb->name) ?></td>
            </tr>
            <tr>
                <th><?= __('Description') ?></th>
                <td><?= h($cmdb->description) ?></td>
            </tr>
            <tr>
                <th><?= __('Created At') ?></th>
                <td><?= h($cmdb->created_at) ?></td>
            </tr>
            <tr>
                <th><?= __('Operating System') ?></th>
                <td><?= h($cmdb->operating_system) ?></td>
            </tr>
            <tr>
                <th><?= __('Group At') ?></th>
                <td><?= h($cmdb->group_at) ?></td>
            </tr>
            <tr>
                <th><?= __('Dns Domain') ?></th>
                <td><?= h($cmdb->dns_domain) ?></td>
            </tr>
            <tr>
                <th><?= __('Management Type') ?></th>
                <td><?= h($cmdb->management_type) ?></td>
            </tr>
            <tr>
                <th><?= __('Service') ?></th>
                <td><?= h($cmdb->service) ?></td>
            </tr>
            <tr>
                <th><?= __('Status') ?></th>
                <td><?= h($cmdb->status) ?></td>
            </tr>
            <tr>
                <th><?= __('Datacenter') ?></th>
                <td><?= h($cmdb->datacenter) ?></td>
            </tr>
            <tr>
                <th><?= __('Ips') ?></th>
                <td><?= h($cmdb->ips) ?></td>
            </tr>
            <tr>
                <th><?= __('Execute Backup') ?></th>
                <td><?= h($cmdb->execute_backup) ?></td>
            </tr>
            <tr>
                <th><?= __('Tipo De Backup') ?></th>
                <td><?= h($cmdb->tipo_de_backup) ?></td>
            </tr>
            <tr>
                <th><?= __('Monitoring') ?></th>
                <td><?= h($cmdb->monitoring) ?></td>
            </tr>
            <tr>
                <th><?= __('Pci') ?></th>
                <td><?= h($cmdb->pci) ?></td>
            </tr>
            <tr>
                <th><?= __('Physical Server Associated Company') ?></th>
                <td><?= h($cmdb->physical_server_associated_company) ?></td>
            </tr>
            <tr>
                <th><?= __('Physical Server Associated Number') ?></th>
                <td><?= h($cmdb->physical_server_associated_number) ?></td>
            </tr>
            <tr>
                <th><?= __('Pool') ?></th>
                <td><?= h($cmdb->pool) ?></td>
            </tr>
            <tr>
                <th><?= __('Associated Clusters') ?></th>
                <td><?= h($cmdb->associated_clusters) ?></td>
            </tr>
            <tr>
                <th><?= __('Observation') ?></th>
                <td><?= h($cmdb->observation) ?></td>
            </tr>
            <tr>
                <th><?= __('Deleted At') ?></th>
                <td><?= h($cmdb->deleted_at) ?></td>
            </tr>
            <tr>
                <th><?= __('Id') ?></th>
                <td><?= $this->Number->format($cmdb->id) ?></td>
            </tr>
            <tr>
                <th><?= __('Create Time') ?></th>
                <td><?= h($cmdb->create_time) ?></td>
            </tr>
            <tr>
                <th><?= __('Update Time') ?></th>
                <td><?= h($cmdb->update_time) ?></td>
            </tr>
        </table>
    </div>
    <div class="card-footer d-flex">
        <div class="mr-auto">
            <?= $this->Form->postLink(
                __('Delete'),
                ['action' => 'delete', $cmdb->id],
                ['confirm' => __('Are you sure you want to delete # {0}?', $cmdb->id), 'class' => 'btn btn-danger']
            ) ?>
        </div>
        <div class="ml-auto">
            <?= $this->Html->link(__('Edit'), ['action' => 'edit', $cmdb->id], ['class' => 'btn btn-secondary']) ?>
            <?= $this->Html->link(__('Cancel'), ['action' => 'index'], ['class' => 'btn btn-default']) ?>
        </div>
    </div>
</div>
