<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Cmdb[]|\Cake\Collection\CollectionInterface $cmdb
 */
?>

<?php
$this->assign('title', __('Cmdb'));
$this->Breadcrumbs->add([
    ['title' => __('Home'), 'url' => '/'],
    ['title' => __('List Cmdb')],
]);
?>

<div class="card card-primary card-outline">
    <div class="card-header d-flex flex-column flex-md-row">
        <h2 class="card-title">
            <!-- -->
        </h2>
        <div class="d-flex ml-auto">
            <?= $this->Paginator->limitControl([], null, [
                'label' => false,
                'class' => 'form-control form-control-sm',
                'templates' => ['inputContainer' => '{{content}}']
            ]); ?>
            <?= $this->Html->link(__('New Cmdb'), ['action' => 'add'], ['class' => 'btn btn-primary btn-sm ml-2']) ?>
        </div>
    </div>
    <!-- /.card-header -->
    <div class="card-body table-responsive p-0">
        <table class="table table-hover text-nowrap">
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('name') ?></th>
                    <th><?= $this->Paginator->sort('description') ?></th>
                    <th><?= $this->Paginator->sort('created_at') ?></th>
                    <th><?= $this->Paginator->sort('operating_system') ?></th>
                    <th><?= $this->Paginator->sort('group_at') ?></th>
                    <th><?= $this->Paginator->sort('dns_domain') ?></th>
                    <th><?= $this->Paginator->sort('management_type') ?></th>
                    <th><?= $this->Paginator->sort('service') ?></th>
                    <th><?= $this->Paginator->sort('status') ?></th>
                    <th><?= $this->Paginator->sort('datacenter') ?></th>
                    <th><?= $this->Paginator->sort('ips') ?></th>
                    <th><?= $this->Paginator->sort('execute_backup') ?></th>
                    <th><?= $this->Paginator->sort('tipo_de_backup') ?></th>
                    <th><?= $this->Paginator->sort('monitoring') ?></th>
                    <th><?= $this->Paginator->sort('pci') ?></th>
                    <th><?= $this->Paginator->sort('physical_server_associated_company') ?></th>
                    <th><?= $this->Paginator->sort('physical_server_associated_number') ?></th>
                    <th><?= $this->Paginator->sort('pool') ?></th>
                    <th><?= $this->Paginator->sort('associated_clusters') ?></th>
                    <th><?= $this->Paginator->sort('observation') ?></th>
                    <th><?= $this->Paginator->sort('deleted_at') ?></th>
                    <th><?= $this->Paginator->sort('create_time') ?></th>
                    <th><?= $this->Paginator->sort('update_time') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($cmdb as $cmdb) : ?>
                    <tr>
                        <td><?= $this->Number->format($cmdb->id) ?></td>
                        <td><?= h($cmdb->name) ?></td>
                        <td><?= h($cmdb->description) ?></td>
                        <td><?= h($cmdb->created_at) ?></td>
                        <td><?= h($cmdb->operating_system) ?></td>
                        <td><?= h($cmdb->group_at) ?></td>
                        <td><?= h($cmdb->dns_domain) ?></td>
                        <td><?= h($cmdb->management_type) ?></td>
                        <td><?= h($cmdb->service) ?></td>
                        <td><?= h($cmdb->status) ?></td>
                        <td><?= h($cmdb->datacenter) ?></td>
                        <td><?= h($cmdb->ips) ?></td>
                        <td><?= h($cmdb->execute_backup) ?></td>
                        <td><?= h($cmdb->tipo_de_backup) ?></td>
                        <td><?= h($cmdb->monitoring) ?></td>
                        <td><?= h($cmdb->pci) ?></td>
                        <td><?= h($cmdb->physical_server_associated_company) ?></td>
                        <td><?= h($cmdb->physical_server_associated_number) ?></td>
                        <td><?= h($cmdb->pool) ?></td>
                        <td><?= h($cmdb->associated_clusters) ?></td>
                        <td><?= h($cmdb->observation) ?></td>
                        <td><?= h($cmdb->deleted_at) ?></td>
                        <td><?= h($cmdb->create_time) ?></td>
                        <td><?= h($cmdb->update_time) ?></td>
                        <td class="actions">
                            <?= $this->Html->link(__('View'), ['action' => 'view', $cmdb->id], ['class' => 'btn btn-xs btn-outline-primary', 'escape' => false]) ?>
                            <?= $this->Html->link(__('Edit'), ['action' => 'edit', $cmdb->id], ['class' => 'btn btn-xs btn-outline-primary', 'escape' => false]) ?>
                            <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $cmdb->id], ['class' => 'btn btn-xs btn-outline-danger', 'escape' => false, 'confirm' => __('Are you sure you want to delete # {0}?', $cmdb->id)]) ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <!-- /.card-body -->
    <div class="card-footer d-flex flex-column flex-md-row">
        <div class="text-muted">
            <?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?>
        </div>
        <ul class="pagination pagination-sm mb-0 ml-auto">
            <?= $this->Paginator->first('<i class="fas fa-angle-double-left"></i>', ['escape' => false]) ?>
            <?= $this->Paginator->prev('<i class="fas fa-angle-left"></i>', ['escape' => false]) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next('<i class="fas fa-angle-right"></i>', ['escape' => false]) ?>
            <?= $this->Paginator->last('<i class="fas fa-angle-double-right"></i>', ['escape' => false]) ?>
        </ul>
    </div>
    <!-- /.card-footer -->
</div>