<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Vulnerabilidade Entity
 *
 * @property int $id
 * @property string|null $grupo
 * @property string|null $servico
 * @property string|null $ip
 * @property string|null $hostname
 * @property string|null $nessus_plugin_id
 * @property string|null $nessus_plugin_cve
 * @property string|null $gravidade
 * @property string|null $score
 * @property string|null $tempo_em_dias
 * @property string|null $visto_em
 * @property string|null $patch
 * @property string|null $cve_critica_comunicada
 * @property string|null $tipo
 * @property string|null $catalogo
 * @property string|null $audit
 * @property \Cake\I18n\Date|null $data_gerado_nessus
 * @property \Cake\I18n\DateTime|null $create_time
 * @property \Cake\I18n\DateTime|null $update_time
 * @property \Cake\I18n\DateTime|null $close_time
 */
class Vulnerabilidade extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'grupo' => true,
        'servico' => true,
        'ip' => true,
        'hostname' => true,
        'nessus_plugin_id' => true,
        'nessus_plugin_cve' => true,
        'gravidade' => true,
        'score' => true,
        'tempo_em_dias' => true,
        'visto_em' => true,
        'patch' => true,
        'cve_critica_comunicada' => true,
        'tipo' => true,
        'catalogo' => true,
        'status_id' => true,
        'audit' => true,
        'data_gerado_nessus' => true,
        'create_time' => true,
        'update_time' => true,
        'close_time' => true,
    ];
    protected function _getIp_host_cve()
    {
        return $this->ip . ' - ' . $this->nessus_plugin_id. ' - ' . $this->nessus_plugin_cve;
    }
    
}
