<?php
declare(strict_types=1);

namespace App\Controller;
use Cake\ORM\TableRegistry;
use Cake\ORM\Locator\LocatorAwareTrait;

/**
 * Vulnerabilidades Controller
 *
 * @property \App\Model\Table\VulnerabilidadesTable $Vulnerabilidades
 */
class VulnerabilidadesController extends AppController
{
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */

    public function index()
    {   
        $query = $this->Vulnerabilidades->find()->contain([ 'Status','Justificativas']);
        $vulnerabilidades = $this->paginate($query);

        $this->set(compact('vulnerabilidades'));
        
    }
    public function search($coluna = null, $operador = null, $valor = null,)
    {
        $coluna = $_GET['coluna'];
        $operador = $_GET['operador'];
        $valor = $_GET['valor'];
        if (empty($coluna)){
            $query = $this->Vulnerabilidades->find()->contain([ 'Status','Justificativas']);
            $vulnerabilidades = $this->paginate($query);
            
        }else{

        
            $query = $this->Vulnerabilidades->find()->contain([ 'Status','Justificativas'])
            ->where([$coluna." ".$operador => $valor]);            
            $vulnerabilidades = $this->paginate($query);

        }
        $this->set(compact('vulnerabilidades'));
        
    }
    public function compacto()
    {
        $query = $this->Vulnerabilidades->find()->contain([ 'Status','Justificativas']);
        $vulnerabilidades = $this->paginate($query);
        $this->set(compact('vulnerabilidades'));
    }

    /**
     * View method
     *
     * @param string|null $id Vulnerabilidade id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $vulnerabilidade = $this->Vulnerabilidades->get($id, contain: []);
        $this->set(compact('vulnerabilidade'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $vulnerabilidade = $this->Vulnerabilidades->newEmptyEntity();
        if ($this->request->is('post')) {
            $vulnerabilidade = $this->Vulnerabilidades->patchEntity($vulnerabilidade, $this->request->getData());
            if ($this->Vulnerabilidades->save($vulnerabilidade)) {
                $this->Flash->success(__('The vulnerabilidade has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The vulnerabilidade could not be saved. Please, try again.'));
        }
        $this->set(compact('vulnerabilidade'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Vulnerabilidade id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $vulnerabilidade = $this->Vulnerabilidades->get($id, contain: []);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $vulnerabilidade = $this->Vulnerabilidades->patchEntity($vulnerabilidade, $this->request->getData());
            if ($this->Vulnerabilidades->save($vulnerabilidade)) {
                $this->Flash->success(__('The vulnerabilidade has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The vulnerabilidade could not be saved. Please, try again.'));
        }
        $this->set(compact('vulnerabilidade'));
    }

    public function editstatus($id = null, $status = null)
    {
        
        $vulnerabilidade = $this->Vulnerabilidades->get($id, contain: []);
        $vulnerabilidade->status_id = $status; 
            if ($this->Vulnerabilidades->save($vulnerabilidade)) {
                $this->Flash->success(__('O status foi alterado.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The vulnerabilidade could not be saved. Please, try again.'));
        
        #$this->set(compact('vulnerabilidade'));
        
        $info[0] = $id;
        $info[1] = $status;
        $this->set(compact('info'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Vulnerabilidade id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $vulnerabilidade = $this->Vulnerabilidades->get($id);
        if ($this->Vulnerabilidades->delete($vulnerabilidade)) {
            $this->Flash->success(__('The vulnerabilidade has been deleted.'));
        } else {
            $this->Flash->error(__('The vulnerabilidade could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }


    public function load($temp_vulnerabilidade = null)
    {
        $novos;
        $reabertos;
        $fechados;
        $x = 0;
        $y = 0;
        $z = 0;
        $temps = TableRegistry::getTableLocator()->get('Temp')->find()->where(['controle =' => 0]);
        foreach ($temps as $temp){ #adição de novas vulnerabilidades
            $vulnerabilidade = $this->Vulnerabilidades->newEmptyEntity();
            $vulnerabilidade->grupo = $temp->grupo;
            $vulnerabilidade->servico = $temp->servico;
            $vulnerabilidade->ip = $temp->ip;
            $vulnerabilidade->hostname = $temp->hostname;
            $vulnerabilidade->nessus_plugin_id = $temp->nessus_plugin_id;
            $vulnerabilidade->nessus_plugin_cve = $temp->nessus_plugin_cve;
            $vulnerabilidade->gravidade = $temp->gravidade;
            $vulnerabilidade->score = $temp->score;
            $vulnerabilidade->visto_em = $temp->visto_em;
            $vulnerabilidade->patch = $temp->patch;
            $vulnerabilidade->cve_critica_comunicada = $temp->cve_critica_comunicada;
            $vulnerabilidade->tipo = $temp->tipo;
            $vulnerabilidade->catalogo = $temp->catalogo;
            $vulnerabilidade->close_time = null;
            if ($this->Vulnerabilidades->save($vulnerabilidade)) {
                $novos[$y]['hostname'] = $temp->hostname;
                $novos[$y]['nessus_plugin_cve'] = $temp->nessus_plugin_cve;
                $y = $y + 1;
            }else{
                $this->Flash->error(__('A vulnerabilidade não pode ser adicionada.'));
            }

        }
        $status2temps = TableRegistry::getTableLocator()->get('Temp')->find()->where(['controle =' => 2]); #Reabre vulnerabilidades
        if(!is_null($status2temps)){
            foreach ($status2temps as $status2temp){
                $result = $this->fetchTable('Vulnerabilidades')->find()->where(['ip =' => $status2temp->ip,'nessus_plugin_cve =' => $status2temp->nessus_plugin_cve])->all()->toList();
                if (!empty($result)) {
                    $vulnerabilidade = $this->Vulnerabilidades->get($result[0]->id);
                    $vulnerabilidade->close_time = null;
                    $vulnerabilidade->status_id = 10;
                    if ($this->Vulnerabilidades->save($vulnerabilidade)) {
                        $reabertos[$x]['hostname'] = $vulnerabilidade->hostname;
                        $reabertos[$x]['nessus_plugin_cve'] = $vulnerabilidade->nessus_plugin_cve;
                        $x = $x + 1;
                    }
                }
            }
            
        }
        $vulnerabilidades = $this->Vulnerabilidades->find()->where(['close_time is' => Null])->all(); #fechar vulnerabilidades
        foreach ($vulnerabilidades as $vulnerabilidade){
            $result =  TableRegistry::getTableLocator()->get('Temp')->find()->where(['ip =' => $vulnerabilidade->ip,'nessus_plugin_cve =' => $vulnerabilidade->nessus_plugin_cve])->all()->toList();
            if (empty($result)) {
                $vulnerabilidade->close_time = time();
                $vulnerabilidade->status_id = 11;
                if ($this->Vulnerabilidades->save($vulnerabilidade)) {
                    $fechados[$z]['hostname'] = $vulnerabilidade->hostname;
                    $fechados[$z]['nessus_plugin_cve'] = $vulnerabilidade->nessus_plugin_cve;
                    $z = $z + 1;
                }
            }
        
            
        }    

        $this->set(compact('novos','reabertos','fechados'));
    }
    
}
