<?php
declare(strict_types=1);

namespace App\Controller;

/**
 * Ambientesvsresponsaveis Controller
 *
 * @property \App\Model\Table\AmbientesvsresponsaveisTable $Ambientesvsresponsaveis
 */
class AmbientesvsresponsaveisController extends AppController
{
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $query = $this->Ambientesvsresponsaveis->find();
        $ambientesvsresponsaveis = $this->paginate($query);

        $this->set(compact('ambientesvsresponsaveis'));
    }

    /**
     * View method
     *
     * @param string|null $id Ambientesvsresponsavei id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $ambientesvsresponsavei = $this->Ambientesvsresponsaveis->get($id, contain: []);
        $this->set(compact('ambientesvsresponsavei'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $ambientesvsresponsavei = $this->Ambientesvsresponsaveis->newEmptyEntity();
        if ($this->request->is('post')) {
            $ambientesvsresponsavei = $this->Ambientesvsresponsaveis->patchEntity($ambientesvsresponsavei, $this->request->getData());
            if ($this->Ambientesvsresponsaveis->save($ambientesvsresponsavei)) {
                $this->Flash->success(__('The ambientesvsresponsavei has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The ambientesvsresponsavei could not be saved. Please, try again.'));
        }
        $this->set(compact('ambientesvsresponsavei'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Ambientesvsresponsavei id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $ambientesvsresponsavei = $this->Ambientesvsresponsaveis->get($id, contain: []);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $ambientesvsresponsavei = $this->Ambientesvsresponsaveis->patchEntity($ambientesvsresponsavei, $this->request->getData());
            if ($this->Ambientesvsresponsaveis->save($ambientesvsresponsavei)) {
                $this->Flash->success(__('The ambientesvsresponsavei has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The ambientesvsresponsavei could not be saved. Please, try again.'));
        }
        $this->set(compact('ambientesvsresponsavei'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Ambientesvsresponsavei id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $ambientesvsresponsavei = $this->Ambientesvsresponsaveis->get($id);
        if ($this->Ambientesvsresponsaveis->delete($ambientesvsresponsavei)) {
            $this->Flash->success(__('The ambientesvsresponsavei has been deleted.'));
        } else {
            $this->Flash->error(__('The ambientesvsresponsavei could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
