<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query\SelectQuery;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Vulnerabilidades Model
 *
 * @method \App\Model\Entity\Vulnerabilidade newEmptyEntity()
 * @method \App\Model\Entity\Vulnerabilidade newEntity(array $data, array $options = [])
 * @method array<\App\Model\Entity\Vulnerabilidade> newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Vulnerabilidade get(mixed $primaryKey, array|string $finder = 'all', \Psr\SimpleCache\CacheInterface|string|null $cache = null, \Closure|string|null $cacheKey = null, mixed ...$args)
 * @method \App\Model\Entity\Vulnerabilidade findOrCreate($search, ?callable $callback = null, array $options = [])
 * @method \App\Model\Entity\Vulnerabilidade patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method array<\App\Model\Entity\Vulnerabilidade> patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\Vulnerabilidade|false save(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method \App\Model\Entity\Vulnerabilidade saveOrFail(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method iterable<\App\Model\Entity\Vulnerabilidade>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Vulnerabilidade>|false saveMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Vulnerabilidade>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Vulnerabilidade> saveManyOrFail(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Vulnerabilidade>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Vulnerabilidade>|false deleteMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Vulnerabilidade>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Vulnerabilidade> deleteManyOrFail(iterable $entities, array $options = [])
 */
class VulnerabilidadesTable extends Table
{
    /**
     * Initialize method
     *
     * @param array<string, mixed> $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('vulnerabilidades');
        $this->setDisplayField('ip_host_cve');
        $this->setPrimaryKey('id');
        $this->belongsTo('Status', [
            'foreignKey' => 'status_id',
            'joinType' => 'INNER',
        ]);
        $this->hasOne('Justificativas');
        $this->addBehavior('Timestamp', [
            'events' => [
                'Model.beforeSave' => [
                    'create_time' => 'new',
                    'update_time' => 'always',
            ]
            
        ]]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->scalar('grupo')
            ->maxLength('grupo', 512)
            ->allowEmptyString('grupo');

        $validator
            ->scalar('servico')
            ->maxLength('servico', 512)
            ->allowEmptyString('servico');

        $validator
            ->scalar('ip')
            ->maxLength('ip', 512)
            ->allowEmptyString('ip');

        $validator
            ->scalar('hostname')
            ->maxLength('hostname', 512)
            ->allowEmptyString('hostname');

        $validator
            ->scalar('nessus_plugin_id')
            ->maxLength('nessus_plugin_id', 512)
            ->allowEmptyString('nessus_plugin_id');

        $validator
            ->scalar('nessus_plugin_cve')
            ->maxLength('nessus_plugin_cve', 512)
            ->allowEmptyString('nessus_plugin_cve');

        $validator
            ->scalar('gravidade')
            ->maxLength('gravidade', 512)
            ->allowEmptyString('gravidade');

        $validator
            ->scalar('score')
            ->maxLength('score', 512)
            ->allowEmptyString('score');

        $validator
            ->scalar('tempo_em_dias')
            ->maxLength('tempo_em_dias', 512)
            ->allowEmptyString('tempo_em_dias');

        $validator
            ->scalar('visto_em')
            ->maxLength('visto_em', 512)
            ->allowEmptyString('visto_em');

        $validator
            ->scalar('patch')
            ->maxLength('patch', 512)
            ->allowEmptyString('patch');

        $validator
            ->scalar('cve_critica_comunicada')
            ->maxLength('cve_critica_comunicada', 512)
            ->allowEmptyString('cve_critica_comunicada');

        $validator
            ->scalar('tipo')
            ->maxLength('tipo', 512)
            ->allowEmptyString('tipo');

        $validator
            ->scalar('catalogo')
            ->maxLength('catalogo', 512)
            ->allowEmptyString('catalogo');

        $validator
            ->scalar('audit')
            ->maxLength('audit', 512)
            ->allowEmptyString('audit');

        $validator
            ->date('data_gerado_nessus')
            ->allowEmptyDate('data_gerado_nessus');

            $validator
            ->integer('status_id')
            ->allowEmptyString('status_id');

        $validator
            ->dateTime('create_time')
            ->allowEmptyDateTime('create_time');

        $validator
            ->dateTime('update_time')
            ->allowEmptyDateTime('update_time');

        $validator
            ->dateTime('close_time')
            ->allowEmptyDateTime('close_time');

        return $validator;
    }
}
