<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query\SelectQuery;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Cmdb Model
 *
 * @method \App\Model\Entity\Cmdb newEmptyEntity()
 * @method \App\Model\Entity\Cmdb newEntity(array $data, array $options = [])
 * @method array<\App\Model\Entity\Cmdb> newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Cmdb get(mixed $primaryKey, array|string $finder = 'all', \Psr\SimpleCache\CacheInterface|string|null $cache = null, \Closure|string|null $cacheKey = null, mixed ...$args)
 * @method \App\Model\Entity\Cmdb findOrCreate($search, ?callable $callback = null, array $options = [])
 * @method \App\Model\Entity\Cmdb patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method array<\App\Model\Entity\Cmdb> patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\Cmdb|false save(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method \App\Model\Entity\Cmdb saveOrFail(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method iterable<\App\Model\Entity\Cmdb>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Cmdb>|false saveMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Cmdb>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Cmdb> saveManyOrFail(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Cmdb>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Cmdb>|false deleteMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Cmdb>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Cmdb> deleteManyOrFail(iterable $entities, array $options = [])
 */
class CmdbTable extends Table
{
    /**
     * Initialize method
     *
     * @param array<string, mixed> $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('cmdb');
        $this->setDisplayField('name');
        $this->setPrimaryKey('id');
        $this->addBehavior('Timestamp', [
            'events' => [
                'Model.beforeSave' => [
                    'create_time' => 'new',
                    'update_time' => 'always',
            ]
            
        ]]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->scalar('name')
            ->maxLength('name', 512)
            ->allowEmptyString('name');

        $validator
            ->scalar('description')
            ->maxLength('description', 512)
            ->allowEmptyString('description');

        $validator
            ->scalar('created_at')
            ->maxLength('created_at', 512)
            ->allowEmptyString('created_at');

        $validator
            ->scalar('operating_system')
            ->maxLength('operating_system', 512)
            ->allowEmptyString('operating_system');

        $validator
            ->scalar('group_at')
            ->maxLength('group_at', 512)
            ->allowEmptyString('group_at');

        $validator
            ->scalar('dns_domain')
            ->maxLength('dns_domain', 512)
            ->allowEmptyString('dns_domain');

        $validator
            ->scalar('management_type')
            ->maxLength('management_type', 512)
            ->allowEmptyString('management_type');

        $validator
            ->scalar('service')
            ->maxLength('service', 512)
            ->allowEmptyString('service');

        $validator
            ->scalar('status')
            ->maxLength('status', 512)
            ->allowEmptyString('status');

        $validator
            ->scalar('datacenter')
            ->maxLength('datacenter', 512)
            ->allowEmptyString('datacenter');

        $validator
            ->scalar('ips')
            ->maxLength('ips', 512)
            ->allowEmptyString('ips');

        $validator
            ->scalar('execute_backup')
            ->maxLength('execute_backup', 512)
            ->allowEmptyString('execute_backup');

        $validator
            ->scalar('tipo_de_backup')
            ->maxLength('tipo_de_backup', 512)
            ->allowEmptyString('tipo_de_backup');

        $validator
            ->scalar('monitoring')
            ->maxLength('monitoring', 512)
            ->allowEmptyString('monitoring');

        $validator
            ->scalar('pci')
            ->maxLength('pci', 512)
            ->allowEmptyString('pci');

        $validator
            ->scalar('physical_server_associated_company')
            ->maxLength('physical_server_associated_company', 512)
            ->allowEmptyString('physical_server_associated_company');

        $validator
            ->scalar('physical_server_associated_number')
            ->maxLength('physical_server_associated_number', 512)
            ->allowEmptyString('physical_server_associated_number');

        $validator
            ->scalar('pool')
            ->maxLength('pool', 512)
            ->allowEmptyString('pool');

        $validator
            ->scalar('associated_clusters')
            ->maxLength('associated_clusters', 512)
            ->allowEmptyString('associated_clusters');

        $validator
            ->scalar('observation')
            ->maxLength('observation', 512)
            ->allowEmptyString('observation');

        $validator
            ->scalar('deleted_at')
            ->maxLength('deleted_at', 512)
            ->allowEmptyString('deleted_at');

        $validator
            ->dateTime('create_time')
            ->allowEmptyDateTime('create_time');

        $validator
            ->dateTime('update_time')
            ->allowEmptyDateTime('update_time');

        return $validator;
    }
}
