<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Cmdb Entity
 *
 * @property int $id
 * @property string|null $name
 * @property string|null $description
 * @property string|null $created_at
 * @property string|null $operating_system
 * @property string|null $group_at
 * @property string|null $dns_domain
 * @property string|null $management_type
 * @property string|null $service
 * @property string|null $status
 * @property string|null $datacenter
 * @property string|null $ips
 * @property string|null $execute_backup
 * @property string|null $tipo_de_backup
 * @property string|null $monitoring
 * @property string|null $pci
 * @property string|null $physical_server_associated_company
 * @property string|null $physical_server_associated_number
 * @property string|null $pool
 * @property string|null $associated_clusters
 * @property string|null $observation
 * @property string|null $deleted_at
 * @property \Cake\I18n\DateTime|null $create_time
 * @property \Cake\I18n\DateTime|null $update_time
 */
class Cmdb extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'name' => true,
        'description' => true,
        'created_at' => true,
        'operating_system' => true,
        'group_at' => true,
        'dns_domain' => true,
        'management_type' => true,
        'service' => true,
        'status' => true,
        'datacenter' => true,
        'ips' => true,
        'execute_backup' => true,
        'tipo_de_backup' => true,
        'monitoring' => true,
        'pci' => true,
        'physical_server_associated_company' => true,
        'physical_server_associated_number' => true,
        'pool' => true,
        'associated_clusters' => true,
        'observation' => true,
        'deleted_at' => true,
        'create_time' => true,
        'update_time' => true,
    ];
}
