<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Vulnerabilidade $vulnerabilidade
 */
 error_reporting(0);
?>

<?php
$this->assign('title', __('Vulnerabilidade'));
$this->Breadcrumbs->add([
    ['title' => __('Home'), 'url' => '/'],
    ['title' => __('List Vulnerabilidades'), 'url' => ['action' => 'index']],
    ['title' => __('View')],
]);
?>

<div class="view card card-primary card-outline">
    <div class="card-header d-sm-flex">
        <h2 class="card-title"><?= h($vulnerabilidade->id) ?></h2>
    </div>
    <div class="card-body table-responsive p-0">
        <table class="table table-hover text-nowrap">
            <tr>
                <th><?= __('Grupo') ?></th>
                <td><?= h($vulnerabilidade->grupo) ?></td>
            </tr>
            <tr>
                <th><?= __('Servico') ?></th>
                <td><?= h($vulnerabilidade->servico) ?></td>
            </tr>
            <tr>
                <th><?= __('Ip') ?></th>
                <td><?= h($vulnerabilidade->ip) ?></td>
            </tr>
            <tr>
                <th><?= __('Hostname') ?></th>
                <td><?= h($vulnerabilidade->hostname) ?></td>
            </tr>
            <tr>
                <th><?= __('Nessus Plugin Id') ?></th>
                <td><?= h($vulnerabilidade->nessus_plugin_id) ?></td>
            </tr>
            <tr>
                <th><?= __('Nessus Plugin Cve') ?></th>
                <td><?= h($vulnerabilidade->nessus_plugin_cve) ?></td>
            </tr>
            <tr>
                <th><?= __('Gravidade') ?></th>
                <td><?= h($vulnerabilidade->gravidade) ?></td>
            </tr>
            <tr>
                <th><?= __('Score') ?></th>
                <td><?= h($vulnerabilidade->score) ?></td>
            </tr>
            <tr>
                <th><?= __('Tempo Em Dias') ?></th>
                <td><?= h($vulnerabilidade->tempo_em_dias) ?></td>
            </tr>
            <tr>
                <th><?= __('Visto Em') ?></th>
                <td><?= h($vulnerabilidade->visto_em) ?></td>
            </tr>
            <tr>
                <th><?= __('Patch') ?></th>
                <td><?= h($vulnerabilidade->patch) ?></td>
            </tr>
            <tr>
                <th><?= __('Cve Critica Comunicada') ?></th>
                <td><?= h($vulnerabilidade->cve_critica_comunicada) ?></td>
            </tr>
            <tr>
                <th><?= __('Tipo') ?></th>
                <td><?= h($vulnerabilidade->tipo) ?></td>
            </tr>
            <tr>
                <th><?= __('Catalogo') ?></th>
                <td><?= h($vulnerabilidade->catalogo) ?></td>
            </tr>
            <tr>
                <th><?= __('Catalogo') ?></th>
                <td><?= h($vulnerabilidade->status_id) ?></td>
            </tr>
            <tr>
                <th><?= __('Audit') ?></th>
                <td><?= h($vulnerabilidade->audit) ?></td>
            </tr>
            <tr>
                <th><?= __('Id') ?></th>
                <td><?= $this->Number->format($vulnerabilidade->id) ?></td>
            </tr>
            <tr>
                <th><?= __('Data Gerado Nessus') ?></th>
                <td><?= h($vulnerabilidade->data_gerado_nessus) ?></td>
            </tr>
            <tr>
                <th><?= __('Create Time') ?></th>
                <td><?= h($vulnerabilidade->create_time) ?></td>
            </tr>
            <tr>
                <th><?= __('Update Time') ?></th>
                <td><?= h($vulnerabilidade->update_time) ?></td>
            </tr>
            <tr>
                <th><?= __('Close Time') ?></th>
                <td><?= h($vulnerabilidade->close_time) ?></td>
            </tr>
        </table>
    </div>
    <div class="card-footer d-flex">
        <div class="mr-auto">
            <?= $this->Form->postLink(
                __('Delete'),
                ['action' => 'delete', $vulnerabilidade->id],
                ['confirm' => __('Are you sure you want to delete # {0}?', $vulnerabilidade->id), 'class' => 'btn btn-danger']
            ) ?>
        </div>
        <div class="ml-auto">
            <?= $this->Html->link(__('Edit'), ['action' => 'edit', $vulnerabilidade->id], ['class' => 'btn btn-secondary']) ?>
            <?= $this->Html->link(__('Cancel'), ['action' => 'index'], ['class' => 'btn btn-default']) ?>
        </div>
    </div>
</div>
