<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Temp> $temp
 */
?>
<div class="temp index content">
    <?= $this->Html->link(__('New Temp'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Temp') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('grupo') ?></th>
                    <th><?= $this->Paginator->sort('servico') ?></th>
                    <th><?= $this->Paginator->sort('ip') ?></th>
                    <th><?= $this->Paginator->sort('hostname') ?></th>
                    <th><?= $this->Paginator->sort('nessus_plugin_id') ?></th>
                    <th><?= $this->Paginator->sort('nessus_plugin_cve') ?></th>
                    <th><?= $this->Paginator->sort('gravidade') ?></th>
                    <th><?= $this->Paginator->sort('score') ?></th>
                    <th><?= $this->Paginator->sort('tempo_em_dias') ?></th>
                    <th><?= $this->Paginator->sort('visto_em') ?></th>
                    <th><?= $this->Paginator->sort('patch') ?></th>
                    <th><?= $this->Paginator->sort('cve_critica_comunicada') ?></th>
                    <th><?= $this->Paginator->sort('tipo') ?></th>
                    <th><?= $this->Paginator->sort('catalogo') ?></th>
                    <th><?= $this->Paginator->sort('audit') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($temp as $temp): ?>
                <tr>
                    <td><?= $this->Number->format($temp->id) ?></td>
                    <td><?= h($temp->grupo) ?></td>
                    <td><?= h($temp->servico) ?></td>
                    <td><?= h($temp->ip) ?></td>
                    <td><?= h($temp->hostname) ?></td>
                    <td><?= h($temp->nessus_plugin_id) ?></td>
                    <td><?= h($temp->nessus_plugin_cve) ?></td>
                    <td><?= h($temp->gravidade) ?></td>
                    <td><?= h($temp->score) ?></td>
                    <td><?= h($temp->tempo_em_dias) ?></td>
                    <td><?= h($temp->visto_em) ?></td>
                    <td><?= h($temp->patch) ?></td>
                    <td><?= h($temp->cve_critica_comunicada) ?></td>
                    <td><?= h($temp->tipo) ?></td>
                    <td><?= h($temp->catalogo) ?></td>
                    <td><?= h($temp->audit) ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $temp->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $temp->id]) ?>
                        <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $temp->id], ['confirm' => __('Are you sure you want to delete # {0}?', $temp->id)]) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>