<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Status $status
 */
?>

<?php
$this->assign('title', __('Status'));
$this->Breadcrumbs->add([
    ['title' => __('Home'), 'url' => '/'],
    ['title' => __('List Status'), 'url' => ['action' => 'index']],
    ['title' => __('View')],
]);
?>

<div class="view card card-primary card-outline">
    <div class="card-header d-sm-flex">
        <h2 class="card-title"><?= h($status->id) ?></h2>
    </div>
    <div class="card-body table-responsive p-0">
        <table class="table table-hover text-nowrap">
            <tr>
                <th><?= __('Status') ?></th>
                <td><?= h($status->status) ?></td>
            </tr>
            <tr>
                <th><?= __('Descricao') ?></th>
                <td><?= h($status->descricao) ?></td>
            </tr>
            <tr>
                <th><?= __('Id') ?></th>
                <td><?= $this->Number->format($status->id) ?></td>
            </tr>
            <tr>
                <th><?= __('Create Time') ?></th>
                <td><?= h($status->create_time) ?></td>
            </tr>
            <tr>
                <th><?= __('Update Time') ?></th>
                <td><?= h($status->update_time) ?></td>
            </tr>
        </table>
    </div>
    <div class="card-footer d-flex">
        <div class="mr-auto">
            <?= $this->Form->postLink(
                __('Delete'),
                ['action' => 'delete', $status->id],
                ['confirm' => __('Are you sure you want to delete # {0}?', $status->id), 'class' => 'btn btn-danger']
            ) ?>
        </div>
        <div class="ml-auto">
            <?= $this->Html->link(__('Edit'), ['action' => 'edit', $status->id], ['class' => 'btn btn-secondary']) ?>
            <?= $this->Html->link(__('Cancel'), ['action' => 'index'], ['class' => 'btn btn-default']) ?>
        </div>
    </div>
</div>

<div class="related related-justificativa view card">
    <div class="card-header d-flex">
        <h3 class="card-title"><?= __('Related Justificativas') ?></h3>
        <div class="ml-auto">
            <?= $this->Html->link(__('New Justificativa'), ['controller' => 'Justificativas', 'action' => 'add', '?' => ['status_id' => $status->id]], ['class' => 'btn btn-primary btn-sm']) ?>
            <?= $this->Html->link(__('List Justificativas'), ['controller' => 'Justificativas', 'action' => 'index'], ['class' => 'btn btn-primary btn-sm']) ?>
        </div>
    </div>
    <div class="card-body table-responsive p-0">
        <table class="table table-hover text-nowrap">
            <tr>
                <th><?= __('Id') ?></th>
                <th><?= __('Vulnerabilidades Id') ?></th>
                <th><?= __('Status Id') ?></th>
                <th><?= __('Descricao') ?></th>
                <th><?= __('Data Alvo') ?></th>
                <th><?= __('Create Time') ?></th>
                <th><?= __('Update Time') ?></th>
                <th class="actions"><?= __('Actions') ?></th>
            </tr>
            <?php if (empty($status->justificativas)) : ?>
                <tr>
                    <td colspan="8" class="text-muted">
                        <?= __('Justificativas record not found!') ?>
                    </td>
                </tr>
            <?php else : ?>
                <?php foreach ($status->justificativas as $justificativa) : ?>
                    <tr>
                        <td><?= h($justificativa->id) ?></td>
                        <td><?= h($justificativa->vulnerabilidades_id) ?></td>
                        <td><?= h($justificativa->status_id) ?></td>
                        <td><?= h($justificativa->descricao) ?></td>
                        <td><?= h($justificativa->data_alvo) ?></td>
                        <td><?= h($justificativa->create_time) ?></td>
                        <td><?= h($justificativa->update_time) ?></td>
                        <td class="actions">
                            <?= $this->Html->link(__('View'), ['controller' => 'Justificativas', 'action' => 'view', $justificativa->id], ['class' => 'btn btn-xs btn-outline-primary']) ?>
                            <?= $this->Html->link(__('Edit'), ['controller' => 'Justificativas', 'action' => 'edit', $justificativa->id], ['class' => 'btn btn-xs btn-outline-primary']) ?>
                            <?= $this->Form->postLink(__('Delete'), ['controller' => 'Justificativas', 'action' => 'delete', $justificativa->id], ['class' => 'btn btn-xs btn-outline-danger', 'confirm' => __('Are you sure you want to delete # {0}?', $justificativa->id)]) ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </table>
    </div>
</div>
