<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Justificativa[]|\Cake\Collection\CollectionInterface $justificativas
 */
?>

<?php
$this->assign('title', __('Justificativas'));
$this->Breadcrumbs->add([
    ['title' => __('Home'), 'url' => '/'],
    ['title' => __('List Justificativas')],
]);
?>

<div class="card card-primary card-outline">
    <div class="card-header d-flex flex-column flex-md-row">
        <h2 class="card-title">
            <!-- -->
        </h2>
        <div class="d-flex ml-auto">
            <?= $this->Paginator->limitControl([], null, [
                'label' => false,
                'class' => 'form-control form-control-sm',
                'templates' => ['inputContainer' => '{{content}}']
            ]); ?>
            <?= $this->Html->link(__('New Justificativa'), ['action' => 'add'], ['class' => 'btn btn-primary btn-sm ml-2']) ?>
        </div>
    </div>
    <!-- /.card-header -->
    <div class="card-body table-responsive p-0">
        <table class="table table-hover text-nowrap">
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('IP') ?></th>
                    <th><?= $this->Paginator->sort('Hostname') ?></th>
                    <th><?= $this->Paginator->sort('Nessus CVE') ?></th>
                    <th><?= $this->Paginator->sort('descricao') ?></th>
                    <th><?= $this->Paginator->sort('data_alvo') ?></th>

                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($justificativas as $justificativa) : ?>
                    <tr>
                        <td><?= $this->Number->format($justificativa->id) ?></td>
                        <td><?= $justificativa->has('vulnerabilidade') ? $this->Html->link($justificativa->vulnerabilidade->ip, ['controller' => 'Vulnerabilidades', 'action' => 'view', $justificativa->vulnerabilidade->id]) : '' ?></td>
                        <td><?= h($justificativa->vulnerabilidade->hostname) ?></td>
                        <td><?= h($justificativa->vulnerabilidade->nessus_plugin_cve) ?></td>
                        <td><?= h($justificativa->descricao) ?></td>
                        <td><?= h($justificativa->data_alvo) ?></td>

                        <td class="actions">
                            <?= $this->Html->link(__('Edit'), ['action' => 'edit', $justificativa->id], ['class' => 'btn btn-xs btn-outline-primary', 'escape' => false]) ?>
                            <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $justificativa->id], ['class' => 'btn btn-xs btn-outline-danger', 'escape' => false, 'confirm' => __('Are you sure you want to delete # {0}?', $justificativa->id)]) ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <!-- /.card-body -->
    <div class="card-footer d-flex flex-column flex-md-row">
        <div class="text-muted">
            <?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?>
        </div>
        <ul class="pagination pagination-sm mb-0 ml-auto">
            <?= $this->Paginator->first('<i class="fas fa-angle-double-left"></i>', ['escape' => false]) ?>
            <?= $this->Paginator->prev('<i class="fas fa-angle-left"></i>', ['escape' => false]) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next('<i class="fas fa-angle-right"></i>', ['escape' => false]) ?>
            <?= $this->Paginator->last('<i class="fas fa-angle-double-right"></i>', ['escape' => false]) ?>
        </ul>
    </div>
    <!-- /.card-footer -->
</div>