<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Cmdb $cmdb
 */
?>

<?php
$this->assign('title', __('Edit Cmdb'));
$this->Breadcrumbs->add([
    ['title' => __('Home'), 'url' => '/'],
    ['title' => __('List Cmdb'), 'url' => ['action' => 'index']],
    ['title' => __('View'), 'url' => ['action' => 'view', $cmdb->id]],
    ['title' => __('Edit')],
]);
?>

<div class="card card-primary card-outline">
    <?= $this->Form->create($cmdb) ?>
    <div class="card-body">
        <?= $this->Form->control('name') ?>
        <?= $this->Form->control('description') ?>
        <?= $this->Form->control('created_at') ?>
        <?= $this->Form->control('operating_system') ?>
        <?= $this->Form->control('group_at') ?>
        <?= $this->Form->control('dns_domain') ?>
        <?= $this->Form->control('management_type') ?>
        <?= $this->Form->control('service') ?>
        <?= $this->Form->control('status') ?>
        <?= $this->Form->control('datacenter') ?>
        <?= $this->Form->control('ips') ?>
        <?= $this->Form->control('execute_backup') ?>
        <?= $this->Form->control('tipo_de_backup') ?>
        <?= $this->Form->control('monitoring') ?>
        <?= $this->Form->control('pci') ?>
        <?= $this->Form->control('physical_server_associated_company') ?>
        <?= $this->Form->control('physical_server_associated_number') ?>
        <?= $this->Form->control('pool') ?>
        <?= $this->Form->control('associated_clusters') ?>
        <?= $this->Form->control('observation') ?>
        <?= $this->Form->control('deleted_at') ?>

    </div>
    <div class="card-footer d-flex">
        <div class="mr-auto">
            <?= $this->Form->postLink(
                __('Delete'),
                ['action' => 'delete', $cmdb->id],
                ['confirm' => __('Are you sure you want to delete # {0}?', $cmdb->id), 'class' => 'btn btn-danger']
            ) ?>
        </div>
        <div class="ml-auto">
            <?= $this->Form->button(__('Save'), ['class' => 'btn btn-primary']) ?>
            <?= $this->Html->link(__('Cancel'), ['action' => 'view', $cmdb->id], ['class' => 'btn btn-default']) ?>
        </div>
    </div>
    <?= $this->Form->end() ?>
</div>