<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query\SelectQuery;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Justificativas Model
 *
 * @property \App\Model\Table\VulnerabilidadesTable&\Cake\ORM\Association\BelongsTo $Vulnerabilidades
 * @property \App\Model\Table\StatusTable&\Cake\ORM\Association\BelongsTo $Status
 *
 * @method \App\Model\Entity\Justificativa newEmptyEntity()
 * @method \App\Model\Entity\Justificativa newEntity(array $data, array $options = [])
 * @method array<\App\Model\Entity\Justificativa> newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Justificativa get(mixed $primaryKey, array|string $finder = 'all', \Psr\SimpleCache\CacheInterface|string|null $cache = null, \Closure|string|null $cacheKey = null, mixed ...$args)
 * @method \App\Model\Entity\Justificativa findOrCreate($search, ?callable $callback = null, array $options = [])
 * @method \App\Model\Entity\Justificativa patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method array<\App\Model\Entity\Justificativa> patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\Justificativa|false save(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method \App\Model\Entity\Justificativa saveOrFail(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method iterable<\App\Model\Entity\Justificativa>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Justificativa>|false saveMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Justificativa>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Justificativa> saveManyOrFail(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Justificativa>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Justificativa>|false deleteMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Justificativa>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Justificativa> deleteManyOrFail(iterable $entities, array $options = [])
 */
class JustificativasTable extends Table
{
    /**
     * Initialize method
     *
     * @param array<string, mixed> $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('justificativas');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');

        $this->belongsTo('Vulnerabilidades', [
            'foreignKey' => 'vulnerabilidade_id',
            'joinType' => 'INNER',
        ]);
        $this->addBehavior('Timestamp', [
            'events' => [
                'Model.beforeSave' => [
                    'create_time' => 'new',
                    'update_time' => 'always',
            ]
            
        ]]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->integer('vulnerabilidades_id')
            ->notEmptyString('vulnerabilidade_id');

        $validator
            ->scalar('descricao')
            ->maxLength('descricao', 512)
            ->allowEmptyString('descricao');

        $validator
            ->date('data_alvo')
            ->allowEmptyDate('data_alvo');

        $validator
            ->dateTime('create_time')
            ->allowEmptyDateTime('create_time');

        $validator
            ->dateTime('update_time')
            ->allowEmptyDateTime('update_time');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules): RulesChecker
    {
        $rules->add($rules->isUnique(['id']), ['errorField' => 'id']);
        $rules->add($rules->existsIn(['vulnerabilidade_id'], 'Vulnerabilidades'), ['errorField' => 'vulnerabilidades_id']);
        $rules->add($rules->isUnique(['vulnerabilidade_id']),"Deve existir apenas uma justificativa por vulnerabilidade");

        return $rules;
    }
}
