<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query\SelectQuery;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Ambientesvsresponsaveis Model
 *
 * @method \App\Model\Entity\Ambientesvsresponsavei newEmptyEntity()
 * @method \App\Model\Entity\Ambientesvsresponsavei newEntity(array $data, array $options = [])
 * @method array<\App\Model\Entity\Ambientesvsresponsavei> newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Ambientesvsresponsavei get(mixed $primaryKey, array|string $finder = 'all', \Psr\SimpleCache\CacheInterface|string|null $cache = null, \Closure|string|null $cacheKey = null, mixed ...$args)
 * @method \App\Model\Entity\Ambientesvsresponsavei findOrCreate($search, ?callable $callback = null, array $options = [])
 * @method \App\Model\Entity\Ambientesvsresponsavei patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method array<\App\Model\Entity\Ambientesvsresponsavei> patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\Ambientesvsresponsavei|false save(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method \App\Model\Entity\Ambientesvsresponsavei saveOrFail(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method iterable<\App\Model\Entity\Ambientesvsresponsavei>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Ambientesvsresponsavei>|false saveMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Ambientesvsresponsavei>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Ambientesvsresponsavei> saveManyOrFail(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Ambientesvsresponsavei>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Ambientesvsresponsavei>|false deleteMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Ambientesvsresponsavei>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Ambientesvsresponsavei> deleteManyOrFail(iterable $entities, array $options = [])
 */
class AmbientesvsresponsaveisTable extends Table
{
    /**
     * Initialize method
     *
     * @param array<string, mixed> $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('ambientesvsresponsaveis');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');
        
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->scalar('ambientes')
            ->maxLength('ambientes', 45)
            ->allowEmptyString('ambientes')
            ->add('ambientes', 'unique', ['rule' => 'validateUnique', 'provider' => 'table']);

        $validator
            ->scalar('responsavel1')
            ->maxLength('responsavel1', 45)
            ->allowEmptyString('responsavel1');

        $validator
            ->scalar('Responsavel2')
            ->maxLength('Responsavel2', 45)
            ->allowEmptyString('Responsavel2');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules): RulesChecker
    {
        $rules->add($rules->isUnique(['ambientes'], ['allowMultipleNulls' => true]), ['errorField' => 'ambientes']);

        return $rules;
    }
}
