<?php
declare(strict_types=1);

namespace App\Controller;

/**
 * Cmdb Controller
 *
 * @property \App\Model\Table\CmdbTable $Cmdb
 */
class CmdbController extends AppController
{
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $query = $this->Cmdb->find();
        $cmdb = $this->paginate($query);

        $this->set(compact('cmdb'));
    }

    /**
     * View method
     *
     * @param string|null $id Cmdb id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $cmdb = $this->Cmdb->get($id, contain: []);
        $this->set(compact('cmdb'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $cmdb = $this->Cmdb->newEmptyEntity();
        if ($this->request->is('post')) {
            $cmdb = $this->Cmdb->patchEntity($cmdb, $this->request->getData());
            if ($this->Cmdb->save($cmdb)) {
                $this->Flash->success(__('The cmdb has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The cmdb could not be saved. Please, try again.'));
        }
        $this->set(compact('cmdb'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Cmdb id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $cmdb = $this->Cmdb->get($id, contain: []);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $cmdb = $this->Cmdb->patchEntity($cmdb, $this->request->getData());
            if ($this->Cmdb->save($cmdb)) {
                $this->Flash->success(__('The cmdb has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The cmdb could not be saved. Please, try again.'));
        }
        $this->set(compact('cmdb'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Cmdb id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $cmdb = $this->Cmdb->get($id);
        if ($this->Cmdb->delete($cmdb)) {
            $this->Flash->success(__('The cmdb has been deleted.'));
        } else {
            $this->Flash->error(__('The cmdb could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
